
; Mains Power Up and Sequencer cycle version
; sequences mains power applied to outlets
; sequence delay set with VR1. S3 selects whether there is a return to start delay and multiplied by a factor set with S1 and S2

; Sequence is Out1 on for sequence delay then off, Out2 on for sequence delay then off, Out3 on for sequence delay then off, Out4 on for sequence delay then off,
; return to Out1 on uses return delay that can be minimal if only main unit used with no daisy chaining
; For daisy chaining, OUT4 off to OUT1 on uses return delay that is also multiplied by x1, x2, x3 or x4 of return delay setting to cater for daisy chaining
; and multiplier depends on how many outlets used in daisy chain unit. 
; multiplier options selected with S1 and S2

; Main and daisy chain units start on mains detect input. Main unit requires pins 5 and 4 of IC11 position bridged so mains detect is operational.

; Single Master unit. 

; Link pins 4 and 5 of IC11 position
; select number of outlets see table 1
; Set S3 open for no return delay 
; set VR1 for required on period of each outlet

; with daisy chaining

; Master unit
; Link pins 4 and 5 of IC11 position 
; Set S3 closed for return delay to allow daisy chain unit to run before OUT1 repowered
; Select return delay extension depending on 1,2,3 or 4 outlets on daisychain unit.

; Daisy chain unit
; build mains input detection, triggered after mains detect but powers OUT1 only after mains detection is off
;(ie after master last output is on then off)
; select number of outlets see table 1 
; Set S3 open for no return delay 
; set VR1 for time period slightly shorter than master unit so finished before Master starts again

; Optional phantom appliance bypass (RA3 to 0V) uses current detection. Current transformer needs main active wire
; through core instead of just OUTLET1. Also bridge the original primary at CON7.  


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F1459
	#include p16f1459.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_OFF & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF &_IESO_OFF & _FCMEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_24MHz & _PLLMULT_4x & _PLLEN_DISABLED & _STVREN_ON & _BORV_HI & _LPBOR_OFF & _LVP_OFF 

;..................................................................................................................................
; define;
; Bank 0 RAM 
; Stored data

START_COUNT			equ	H'20'		; start counter
MASTR_DSY			equ	H'21'		; detects master or daisychain unit (detects mains input at power up) High for master, low for daisychain
MULTIPLIER			equ	H'22'		; delay multiplier
NUMBER				equ	H'23'		; number of outlets selected at RA0,RA1
S1_S2				equ	H'24'		; PORTB switches settings
DELAY_MULT			equ	H'25'		; timer multiplier for return delay if daisy chain connected
; A/D readings
SEQ_RATE			equ	H'26'		; rate of switching on outputs	
CURRENT0			equ	H'27'		; current detect or daisy chain input voltage ms byte
CURRENT1			equ	H'28'		; current detect or daisy chain input voltage ls byte
VALUEI				equ	H'29'		; VR1 value after 28 subtracted

; All Banks RAM

TEMP_VAL			equ	H'70'		; temporary value for ms byte in read and A/D conversion ms byte store 
STORE1				equ	H'71'		; delay counter	1
STORE2				equ	H'72'		; delay counter 2
STORE3				equ	H'73'		; delay extender by 79
TEMP				equ	H'74'		; temporary register for delay in A/D conversion

;.................................................................
	org		0
	goto	MAIN
	org     4				; interrupt vector not used
	nop

MAIN
	clrf	START_COUNT		; start counter

; set inputs/outputs
	movlb	D'2'			; latch, bank 2
	movlw	B'00001000'	; 
	movwf	LATA
	movlw	B'00000000'	; 
	movwf	LATB
	movlw	B'00000000'	; 
	movwf	LATC

;USB
	movlb	D'29'
	bcf		UCON,3		; USB off
	bcf		UCON,1
	
; weak pullups off/on
	movlb	D'4'		; bank4	WPUA/B
	clrf	WPUA
	movlw	B'11100000' ; RB7,RB6,RB5 to S2,S3,S1
	movwf	WPUB

; set I/O
	movlb	D'1'		; bank1	TRISA/B/C
	movlw   B'00001000'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'11100000'	; I/O 
	movwf	TRISB		; port B data direction register
	movlw	B'00001001'
	movwf	TRISC		; port C data direction 
; options
	movlw	B'00000111'	; weak pullups set via WPUA/B TMR0/256
	movwf	OPTION_REG	; 
; analog inputs
	movlb	D'3'		; bank3	ANSELA/B/C  AN4, AN7
	movlw	B'00000000'	; 
	movwf	ANSELA
	movlw	B'00000000' ; 
	movwf	ANSELB
	movlw	B'00001001'	; AN7,AN4  VR1,Current/daisy chain voltage
	movwf	ANSELC
; A/D select
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011100'	; channel 7 start 
; 00010000 	; channel 4	; Current detection or Daisy chain voltage
; 00011100	; channel 7	; VR1
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on

; oscillator	
	movlw	B'00110100'	; for 4MHz;
	movwf	OSCCON		; osc

; start up delay
	call	DELAYxms	; 300ms
		
; A/D conversion
; Channel 7 A/D value for VR1

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011100'	; channel 7  
; 00011100	; channel 7	; VR1
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	bcf		INTCON,GIE

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT1
	decfsz	TEMP,f
	goto	WAIT1	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	movf	ADRESH,w
	btfsc	STATUS,Z		; if 0 set at 1
	movlw	D'1'
	movlb	D'0'			; bank 0
	movwf	SEQ_RATE

; check RA3. If high goto VI_DETECT_LOOP
; if low bypass and go to NOW_STRT (uses current detection to determine whether to keep powering outlet or move to next one

	btfss	PORTA,3			; was MCLR but now an input for current detection phantom appliance bypass
	goto	NOW_STRT

; input mains voltage or current detect loop. If Master unit the voltage will read about 902mV if IC10 and 2.2k attached
; higher at 4.5V if these parts are out.  
VI_DETECT_LOOP	

	call	READ_CURRENT_MAINS
	goto	FIRST

;...................................................................
READ_CURRENT_MAINS ; subroutine
; check if voltage at current or mains detect

; check AN4 for voltage	
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw	B'00010000'		; channel 4 Current detection/Daisy chain voltage
	movwf	ADCON0
	movlw	B'10010000'		; right justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT3
	decfsz	TEMP,f
	goto	WAIT3	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV3
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV3
	movf	ADRESH,w		; ms byte
	movwf	TEMP_VAL		; store in all banks RAM
	movf	ADRESL,w		; ls bits
	movlb	D'0'			; bank 0
	movwf	CURRENT1		; ls byte
	movf	TEMP_VAL,w
	movwf	CURRENT0		; ms byte of current detect or daisy chain voltage

; COMPARE
; check if high enough >398mV

	movlw	H'00'
	subwf	CURRENT0,w		; subtraction
	movwf	VALUEI			; keep subtraction
	movlw	D'80'			; low byte
	subwf	CURRENT1,w		; subtraction
	btfss	STATUS,C
	decf	VALUEI,f		; reduce high byte subtraction if carry	
	return
;............................................................................

FIRST
; if first detection after power up, set either as master or daisychain version. (if VALUE_I,7 is set then daisychain.)
	movf	START_COUNT,w	; start counter. If zero set MASTR_DSY (master or daisy chain version)
	btfss	STATUS,Z		; if zero, first run after power up
	goto	ON_OR_WAIT
; store detection setting
	movf	VALUEI,w
	movwf	MASTR_DSY
	incf	START_COUNT,f	; set at 1
ON_OR_WAIT
	btfsc	VALUEI,7		; if clear then positive so switch on
	goto	VI_DETECT_LOOP

SWITCH_ON	

	btfss	PORTA,3			; was MCLR but now an input for current detection phantom appliance bypass
	goto	NOW_STRT

; check MASTR_DSY,7 for mains detect and startup delay or start now

	btfss	MASTR_DSY,7
	goto	NOW_STRT		; immediate start

; startup wait for daisy version
; needs to start when there is mains voltage detection
STRT_WAIT
; check AN4 for voltage	
	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfsc	VALUEI,7		; if clear then voltage detected otherwise recheck value
	goto	STRT_WAIT

; add in sequence rate delay for startup (used for daisy chain version)
	call	S_ON_D			; switch on delay

; start after mains voltage detection is not detected

STRT_WAIT2

; check AN4 for voltage	
	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if set switch on otherwise recheck value
	goto	STRT_WAIT2		; wait for power detection off

NOW_STRT
; switch on outlets and off in sequence 

; determine number of outlets set at RA1,RA0
	movf	PORTA,w
	andlw	B'00000011'
	movwf	NUMBER

; Outlet Loop  
;..................................
; OUTLET GPO1 ON
OUT1
; RC1 then RA4, then RC1 off
	movlb	D'2'			; LATA
	bsf		LATC,1			; Triac1 on
	bsf		LATC,4			; Triac1 on
	movlb	D'0'			; PORTA
	call	DELAYxms		; 300ms
;............................................
; check RA3. If low check if appliance is on
	btfsc	PORTA,3
	goto	OUT1_ON	

	movlw	D'7'			; 7 x 100ms
	call	ANYms			; delay 700ms (plus 300ms above =1s before current reading

	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if clear, switch on 
	goto	OUT1_ON

	movlb	D'2'			; bank LATA	
	bcf		LATC,1			; Triac1 off
	bcf		LATC,4			; Triac1 off
	movlb	D'0'			; PORTA	
	call	DELAYms			; 100ms
	goto	COMPARE1		; last or next outlet
;............................................
OUT1_ON

; then RA4, then RC1 off
	movlb	D'2'			; LATA
	bsf		LATA,4			; RELAY1 on
	movlb	D'0'        	; PORTA
; delay before Triac off for time for relay closure	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATC,1			; Triac1 off
	bcf		LATC,4			; Triac1 off
	movlb	D'0'        	; PORTA

; on delay
; check RA3. If low check if appliance is still on
	btfsc	PORTA,3
	goto	OUT1_CONTINUE
;..........................................	
	movlw	D'79'			;  79 for 8s to 30 minutes
	movwf	STORE3
OUT1_LOOP
	call	DELAYms			; 100ms delay before reading current again
	decfsz	STORE3,f
	goto	OUT1_ON_Q
	goto	OUT1_OFF

; check if appliance still on
OUT1_ON_Q
	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if set, switch off 
	goto	OUT1_LOOP
	goto	OUT1_OFF
;..........................................

OUT1_CONTINUE
	call	S_ON_D			; on sequence period

; OUTLET GPO1 off
; Triac1 on, relay1 off, Triac1 off 
OUT1_OFF
; GPO1	
	movlb	D'2'			; bank LATA	
	bsf		LATC,1			; Triac1 on
	bsf		LATC,4			; Triac1 on
	call	DELAYms
	bcf		LATA,4			; Relay1 off
	call	DELAYms
	bcf		LATC,1			; Triac1 off
	bcf		LATC,4			; Triac1 on
	movlb	D'0'			; PORTA	
	call	DELAYms			; 100ms

COMPARE1		; last or next outlet
; check outlets number set (1,2,3 or4)
	movlb	D'0'			; PORTA	
	movf	NUMBER,w
	xorlw	B'00000011'
	btfsc	STATUS,Z
	goto	END_ON			; just 1 outlet	do return delay if required


;.................................
; then GPO2
OUT2
; RC2 first then RA5, delay  RC2 off 
	movlb	D'2'			; bank LATA
	bsf		LATC,2			; TRIAC2 on
	movlb	D'0' 			; PORTA
	call	DELAYxms		; 300ms

;............................................
; check RA3. If low check if appliance is on
	btfsc	PORTA,3
	goto	OUT2_ON	

	movlw	D'7'			; 7 x 100ms
	call	ANYms			; delay 700ms (plus 300ms above =1s before current reading

	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if clear, switch on 
	goto	OUT2_ON

	movlb	D'2'			; bank LATA	
	bcf		LATC,2			; Triac2 off
	movlb	D'0'			; PORTA	
	call	DELAYms			; 100ms
	goto	COMPARE2		; next outlet
;............................................

OUT2_ON
; then RA5, then RC2 off
	movlb	D'2'			; LATA
	bsf		LATA,5			; RELAY2 on
	movlb	D'0' 			; PORTA
; delay before Triac off	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATC,2			; Triac2 off
	movlb	D'0'        	; PORTA

; on delay
; check RA3. If low check if appliance is still on
	btfsc	PORTA,3
	goto	OUT2_CONTINUE
;..........................................	
	movlw	D'79'			;  79 for 8s to 30 minutes
	movwf	STORE3
OUT2_LOOP
	call	DELAYms			; 100ms delay before reading current again
	decfsz	STORE3,f
	goto	OUT2_ON_Q
	goto	OUT2_OFF

; check if appliance still on
OUT2_ON_Q
	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if set, switch off 
	goto	OUT2_LOOP
	goto	OUT2_OFF
;..........................................

OUT2_CONTINUE

; on delay
	call	S_ON_D			; on sequence period

; Triac2 on, relay2 off, Triac2 off
OUT2_OFF 
; GPO2
	movlb	D'2'			; bank LATA
	bsf		LATC,2			; Triac2 on
	call	DELAYms
	bcf		LATA,5			; Relay2 off
	call	DELAYms
	bcf		LATC,2			; Triac2 off
	call	DELAYms			; 100ms

COMPARE2		; last or next outlet	
; compare 
	movlb	D'0'			; PORTA	
	movf	NUMBER,w
	xorlw	B'00000010'
	btfsc	STATUS,Z
	goto	END_ON			; just 2 outlets


;.................................
; then GPO3 (RB4 ,RC5)
OUT3
	movlb	D'2'			; bank LATA
	bsf		LATB,4			; TRIAC3 on
	movlb	D'0' 			; PORTA
	call	DELAYxms		; 300ms

;............................................
; check RA3. If low check if appliance is on
	btfsc	PORTA,3
	goto	OUT3_ON	

	movlw	D'7'			; 7 x 100ms
	call	ANYms			; delay 700ms (plus 300ms above =1s before current reading

	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if clear, switch on 
	goto	OUT3_ON

	movlb	D'2'			; bank LATA	
	bcf		LATB,4			; Triac3 off
	movlb	D'0'			; PORTA	
	call	DELAYms			; 100ms
	goto	COMPARE3		; last or next outlet			
;............................................

OUT3_ON
; then RA5, then RC2 off
	movlb	D'2'			; LATA
	bsf		LATC,5			; RELAY3 on
	movlb	D'0' 			; PORTA
; delay before Triac off	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATB,4			; Triac3 off
	movlb	D'0'        	; PORTA

; on delay
; check RA3. If low check if appliance is still on
	btfsc	PORTA,3
	goto	OUT3_CONTINUE
;..........................................	
	movlw	D'79'			;  79 for 8s to 30 minutes
	movwf	STORE3
OUT3_LOOP
	call	DELAYms			; 100ms delay before reading current again
	decfsz	STORE3,f
	goto	OUT3_ON_Q
	goto	OUT3_OFF

; check if appliance still on
OUT3_ON_Q
	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if set, switch off 
	goto	OUT3_LOOP
	goto	OUT3_OFF
;..........................................

OUT3_CONTINUE
	call	S_ON_D			; on sequence period

; Triac3 on, relay3 off, Triac3 off 
OUT3_OFF
; GPO3
	movlb	D'2'			; bank LATA
	bsf		LATB,4			; Triac3 on
	call	DELAYms
	bcf		LATC,5			; Relay3 off
	call	DELAYms
	bcf		LATB,4			; Triac3 off
	call	DELAYms			; 100ms
	
COMPARE3		; last or next outlet
; compare 
	movlb	D'0'			; PORTA	
	movf	NUMBER,w
	xorlw	B'00000001'
	btfsc	STATUS,Z
	goto	END_ON			; just 3 outlets

;........................................
OUT4
; then GPO4 (RC7, RC6)
	movlb	D'2'			; bank LATA
	bsf		LATC,7			; TRIAC4 on
	movlb	D'0' 			; PORTA
	call	DELAYxms		; 300ms 

;............................................
; check RA3. If low check if appliance is on
	btfsc	PORTA,3
	goto	OUT4_ON	

	movlw	D'7'			; 7 x 100ms
	call	ANYms			; delay 700ms (plus 300ms above =1s before current reading

	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if clear, switch on 
	goto	OUT4_ON

	movlb	D'2'			; bank LATA	
	bcf		LATC,7			; Triac4 off
	movlb	D'0'			; PORTA	
	call	DELAYms			; 100ms
	goto	END_ON			; last outlet			
;............................................

OUT4_ON
; then RA5, then RC2 off
	movlb	D'2'			; LATA
	bsf		LATC,6			; RELAY4 on
	movlb	D'0' 			; PORTA
; delay before Triac off	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATC,7			; Triac4 off
	movlb	D'0' 			; PORTA

; on delay
; check RA3. If low check if appliance is still on
	btfsc	PORTA,3
	goto	OUT4_CONTINUE
;..........................................	
	movlw	D'79'			; 79 for 8s to 30 minutes
	movwf	STORE3
OUT4_LOOP
	call	DELAYms			; 100ms delay before reading current again
	decfsz	STORE3,f
	goto	OUT4_ON_Q
	goto	OUT4_OFF

; check if appliance still on
OUT4_ON_Q
	call	READ_CURRENT_MAINS; check if voltage at current or mains detect
	
	btfss	VALUEI,7		; if set, switch off 
	goto	OUT4_LOOP
	goto	OUT4_OFF
;..........................................

OUT4_CONTINUE
; on delay
	call	S_ON_D			; on sequence period

OUT4_OFF
; Triac4 on, relay4 off, Triac4 off 
; GPO4
	movlb	D'2'			; bank LATA
	bsf		LATC,7			; Triac4 on
	call	DELAYms			; 100ms
	bcf		LATC,6			; Relay4 off
	call	DELAYms			; 100ms
	bcf		LATC,7			; Triac4 off
	call	DELAYms			; 100ms
	movlb	D'0'			; PORTA	
;.............................................

END_ON	; end of outlets sequence

	btfss	PORTA,3			; was MCLR but now an input for current detection phantom appliance bypass
	goto	NOW_STRT		; bypass 

; S1 RB5
; S2 RB7
; S3 RB6

; at end of sequence determine if directly re cycle loop or wait
; S3 sets whether immediate recycle (open) or use return delay (closed)so can be used with daisy chain unit
; S1 and S2 set the single sequence delay (x1), 2 x sequence delay, 3 x sequence delay or 4 x sequence delay 

; S1		S2		Return delay
; open		open	x4
; closed 	open	x3
; open		closed	x2
; closed 	closed	x1	 

; check S3
	btfsc	PORTB,6	
	goto	SWITCH_ON  	; no return delay

; check S1,S2

	movf	PORTB,w
	andlw	B'10100000'
	movwf	S1_S2
Check4
	xorlw	B'10100000'
	btfsc	STATUS,Z
	goto	X_FOUR
Check3
	movf	S1_S2,w
	xorlw	B'00100000'
	btfsc	STATUS,Z
	goto	X_THREE
Check2
	movf	S1_S2,w
	xorlw	B'10000000'
	btfsc	STATUS,Z
	goto	X_TWO
XONE
	movlw	D'1'
	goto	DO_RETURNX
X_TWO
	movlw	D'2'
	goto	DO_RETURNX
X_THREE
	movlw	D'3'
	goto	DO_RETURNX
X_FOUR
	movlw	D'4'

DO_RETURNX

	movwf	DELAY_MULT
X_RATE

	call	S_ON_D			; on sequence period

	decfsz	DELAY_MULT,f
	goto	X_RATE
; xtra delay ended
	goto	SWITCH_ON   	; return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

S_ON_D		; Switch On PERIOD

	movlw	D'79'	; 79 for 8 seconds to 30 minutes
	movwf	STORE3
XTRA
	movlb	D'0'			; bank 0
	movlw	D'28'			; start at higher setting (~0.5V)
	subwf	SEQ_RATE,w
	btfss	STATUS,C
	movlw	D'1'			; use 1 if negative or 0
	btfsc	STATUS,Z
	movlw	D'1'
	movwf	MULTIPLIER		; working counter

LOOP_ON
	call	DELAYms
	decfsz	MULTIPLIER,f
	goto	LOOP_ON
	decfsz	STORE3,f
	goto	XTRA

	return


;/////////////////////////////////////////////////////////////

; delay loop 

DELAYxms
	movlw	D'3'		; 300ms
ANYms
	movwf	TEMP_VAL
DLYLOOP
	call	DELAYms
	decfsz	TEMP_VAL,f
	goto	DLYLOOP

DELAYms ; 100ms/ cycle
	movlw	D'186'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B2'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return



 end